IF  EXISTS (SELECT * FROM SYS.VIEWS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[V_INFO_PROD_SITEMERCADO_IFOOD]'))
	DROP VIEW [DBO].[V_INFO_PROD_SITEMERCADO_IFOOD]
GO
CREATE VIEW V_INFO_PROD_SITEMERCADO_IFOOD

AS 

SELECT
	EPC.CD_FILIAL				AS IDLOJA,
	EAMD.DS_ARV_MERC_DEPTO		AS DEPARTAMENTO,
	EAMC.DS_ARV_MERC_CATEG		AS CATEGORIA,
	EAMCB.DS_ARV_MERC_CATEG_SUB	AS SUBCATEGORIA,
	0							AS MARCA,
	0							AS UNIDADE,
	0							AS VOLUME,
	EPCB.CD_BARRA				AS CODIGO_BARRA,
	EP.DS_USUAL					AS NOME,
	EP.DT_CAD					AS DT_CADASTRO,
	EP.DT_ULT_ATU				AS DT_ULTIMA_ALTERACAO,
	EPP.VLR_TABELA 				AS VLR_PRODUTO,
	EPP.VLR_OFERTA				AS VLR_PROMOCAO,
	EPC.QT_EST					AS QTD_ESTOQUE_ATUAL,
	0							AS QTD_ESTOQUE_MINIMO,
	EP.DS_PROD					AS DESCRICAO,
	CASE EPC.STS_PROD  
		WHEN 0 THEN 'S'	
		ELSE 'N'
	END							AS ATIVO,
	EPC.CD_PROD					AS PLU,
	EPC.VLR_COMPRA				AS VLR_COMPRA,
	0							AS VALIDADE_PROXIMA,
	0							AS VLR_ATACADO,
	0							AS QTD_ATACADO,
	''							AS IMAGE_URL
FROM 
	EST_PROD_CPL EPC
    INNER JOIN EST_PROD EP ON (
        EP.CD_PROD    		= EPC.CD_PROD
        AND EP.CD_FILIAL 	= EPC.CD_FILIAL
        AND EP.CD_EMP    	= EPC.CD_EMP
	)
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA EPEAMC ON (
		EPEAMC.CD_PROD = EPC.CD_PROD
	)	
	INNER JOIN EST_ARV_MERC_CATEGORIA EAMC ON (
		EAMC.CD_EMP = EPEAMC.CD_EMP
		AND EAMC.CD_ARV_MERC_CATEG = EPEAMC.CD_ARV_MERC_CATEG
	)
	INNER JOIN EST_PROD_CD_BARRA EPCB ON (
		EPCB.CD_PROD    = EPC.CD_PROD
        AND EPCB.CD_EMP = EPC.CD_EMP
	)
	INNER JOIN EST_PROD_PRECO EPP ON (
		EPP.CD_EMP		= EPC.CD_EMP
		AND EPP.CD_FILIAL	= EPC.CD_FILIAL
		AND EPP.CD_PROD		= EPC.CD_PROD
	)
	LEFT JOIN EST_ARV_MERC_CATEGORIA_SUB  EAMCB ON (
		EPEAMC.CD_EMP						= EAMCB.CD_EMP
		AND EPEAMC.CD_ARV_MERC_CATEG_SUB	= EAMCB.CD_ARV_MERC_CATEG_SUB
		AND EPEAMC.CD_ARV_MERC_CATEG		= EAMCB.CD_ARV_MERC_CATEG
	)
	LEFT JOIN EST_ARV_MERC_DEPTO EAMD ON (
		EAMC.CD_EMP = EAMD.CD_EMP
		AND EAMC.CD_ARV_MERC_DEPTO = EAMD.CD_ARV_MERC_DEPTO
	)